/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config;

import frc.emul.config.ConfigSaver;
import frc.emul.config.data.CfgItemAuthor;
import frc.emul.config.data.CfgItemBankMenu;
import frc.emul.config.data.CfgItemCartridgeStandalone;
import frc.emul.config.data.CfgItemCategory;
import frc.emul.config.data.CfgItemController;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameContainer;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.config.data.CfgItemOptions;
import frc.emul.config.data.CfgItemPeripheral;
import frc.emul.config.data.CfgItemRom;
import frc.emul.config.data.CfgItemSeparator;
import frc.emul.config.data.CfgItemTiming;
import frc.emul.periph.Peripherals;
import frc.emul.util.Utils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class Configuration {
    public CfgItemKeymapping keyMapping = new CfgItemKeymapping();
    public CfgItemTiming timing = new CfgItemTiming();
    public CfgItemOptions options = new CfgItemOptions();
    private List<CfgItemController> controllers = new ArrayList<CfgItemController>();
    public List<CfgItemCategory> categories = new ArrayList<CfgItemCategory>();
    public List<CfgItemAuthor> authors = new ArrayList<CfgItemAuthor>();
    public List<CfgItemRom> systems = new ArrayList<CfgItemRom>();
    public List<CfgItemBankMenu> bankMenus = new ArrayList<CfgItemBankMenu>();
    public List<CfgItemGameContainer> games = new ArrayList<CfgItemGameContainer>();
    private CfgItemGame selectedGame;
    public int categoryIdx = 0;
    public int authorIdx = 0;
    public int systemIdx = 0;
    public CfgItemPeripheral[] portsDevices = new CfgItemPeripheral[]{new CfgItemPeripheral(Peripherals.getDefaultPeripheralID(0)), new CfgItemPeripheral(Peripherals.getDefaultPeripheralID(1))};
    public Rectangle window = Configuration.getDefaultWindowBounds();
    public int windowMaxState = 0;
    private boolean controllersDisabled;
    private boolean userGameSeparatorCreated;
    private boolean dirty;
    private boolean debug;
    private final String filename;

    public Configuration() {
        this(null);
    }

    public Configuration(String string) {
        this.filename = string;
    }

    public void override(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.debug = Utils.containsParam(stringArray, "-debug");
        if (Utils.containsParam(stringArray, "-resetbounds")) {
            this.windowMaxState = 0;
            this.window = Configuration.getDefaultWindowBounds();
        }
        Boolean bl = Utils.getSwitchParam(stringArray, "-menu", true);
        Boolean bl2 = Utils.getSwitchParam(stringArray, "-shader", true);
        Boolean bl3 = Utils.getSwitchParam(stringArray, "-sound", true);
        Boolean bl4 = Utils.getSwitchParam(stringArray, "-fullscreen", false);
        Integer n = Utils.getOptionParam(stringArray, "-rotation", 0, 90, 180, 270);
        Boolean bl5 = Utils.getSwitchParam(stringArray, "-wobbling", true);
        if (bl != null) {
            this.options.menuVisible = bl;
        }
        if (bl2 != null) {
            this.options.glowShader.active = bl2;
        }
        if (bl3 != null) {
            this.options.snd_enabled = bl3;
        }
        if (bl4 != null) {
            this.options.display_fullscreen = bl4;
        }
        if (n != null) {
            this.options.display_rotation = n;
        }
        if (bl5 != null) {
            this.options.display_wobbling = bl5;
        }
    }

    private static Rectangle getDefaultWindowBounds() {
        return new Rectangle(-1, -1, -1, -1);
    }

    public boolean save() {
        if (this.filename == null) {
            throw new IllegalStateException("No filename attached to the configuration");
        }
        System.out.println("Saving configuration [" + this.filename + "]");
        boolean bl = ConfigSaver.save(this, this.filename);
        if (bl) {
            this.setDirty(false);
        } else {
            JOptionPane.showMessageDialog(null, "Failed to save the configuration", "ParaJVE - Saving Error...", 2);
        }
        return bl;
    }

    public File getDevPropertiesFile() {
        if (this.filename == null) {
            throw new RuntimeException("No conf filename defined!");
        }
        return new File(new File(this.filename).getParentFile(), "development.properties");
    }

    public boolean isControllersDisabled() {
        return this.controllersDisabled;
    }

    public void setControllersDisabled(boolean bl) {
        this.controllersDisabled = bl;
    }

    public boolean isDebugMode() {
        return this.debug;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public CfgItemController[] getControllers() {
        return this.controllers.toArray(new CfgItemController[this.controllers.size()]);
    }

    public CfgItemController getController(String string) {
        for (CfgItemController cfgItemController : this.controllers) {
            if (!cfgItemController.getID().equals(string)) continue;
            return cfgItemController;
        }
        return null;
    }

    public boolean removeController(String string) {
        int n = this.controllers.size();
        while (n-- > 0) {
            if (!this.controllers.get(n).getID().equals(string)) continue;
            this.controllers.remove(n);
            return true;
        }
        return false;
    }

    public void addController(CfgItemController cfgItemController) {
        this.removeController(cfgItemController.getID());
        this.controllers.add(cfgItemController);
    }

    public CfgItemCategory getCategory(String string) {
        for (CfgItemCategory cfgItemCategory : this.categories) {
            if (!cfgItemCategory.id.equals(string)) continue;
            return cfgItemCategory;
        }
        return null;
    }

    public CfgItemCategory getDefaultCategory() {
        return this.categoryIdx < this.categories.size() ? this.categories.get(this.categoryIdx) : (this.categories.isEmpty() ? null : this.categories.get(0));
    }

    public CfgItemAuthor getAuthor(String string) {
        for (CfgItemAuthor cfgItemAuthor : this.authors) {
            if (!cfgItemAuthor.id.equals(string)) continue;
            return cfgItemAuthor;
        }
        return null;
    }

    public CfgItemAuthor getDefaultAuthor() {
        return this.authorIdx < this.authors.size() ? this.authors.get(this.authorIdx) : (this.authors.isEmpty() ? null : this.authors.get(0));
    }

    public CfgItemRom getSystemRom(String string) {
        for (CfgItemRom cfgItemRom : this.systems) {
            if (!cfgItemRom.id.equals(string)) continue;
            return cfgItemRom;
        }
        return null;
    }

    public CfgItemRom getDefaultSystemRom() {
        return this.systemIdx < this.systems.size() ? this.systems.get(this.systemIdx) : (this.systems.isEmpty() ? null : this.systems.get(0));
    }

    public CfgItemBankMenu getBankMenu(String string) {
        for (CfgItemBankMenu cfgItemBankMenu : this.bankMenus) {
            if (!cfgItemBankMenu.id.equalsIgnoreCase(string)) continue;
            return cfgItemBankMenu;
        }
        return null;
    }

    public CfgItemGame getGame(String string) {
        if (string != null) {
            for (CfgItemGameContainer cfgItemGameContainer : this.games) {
                if (!cfgItemGameContainer.isGame() || !cfgItemGameContainer.game.getID().equals(string)) continue;
                return cfgItemGameContainer.game;
            }
        }
        return null;
    }

    public CfgItemGame getPickedGame() {
        return this.getGame("PICKED");
    }

    public CfgItemGame getBuiltGame() {
        return this.getGame("SOURCE");
    }

    public CfgItemGame getSelectedGame() {
        if (this.selectedGame == null) {
            this.setSelectedGame(null);
        }
        return this.selectedGame;
    }

    public void setSelectedGame(CfgItemGame cfgItemGame) {
        this.selectedGame = cfgItemGame == null ? this.getDefaultGame() : cfgItemGame;
        this.applyGameRequirements(this.selectedGame);
    }

    public CfgItemGame createUserPickedGame(String string) {
        this.createUserGameSeparator();
        CfgItemGame cfgItemGame = this.createGame(this.getPickedGame(), "ROM ", string, "PICKED", 1);
        cfgItemGame.cartridge.picked = true;
        return cfgItemGame;
    }

    public CfgItemGame createUserBuiltGame(String string) {
        this.createUserGameSeparator();
        CfgItemGame cfgItemGame = this.createGame(this.getBuiltGame(), "SOURCE ", string, "SOURCE", 1);
        cfgItemGame.cartridge.built = true;
        return cfgItemGame;
    }

    public void createUserGameSeparator() {
        if (!this.userGameSeparatorCreated) {
            this.userGameSeparatorCreated = true;
            CfgItemSeparator cfgItemSeparator = new CfgItemSeparator();
            CfgItemGameContainer cfgItemGameContainer = new CfgItemGameContainer(cfgItemSeparator);
            cfgItemSeparator.isVolatile = true;
            cfgItemSeparator.label = "User defined games";
            cfgItemSeparator.color = new Color(120, 180, 120);
            this.games.add(cfgItemGameContainer);
        }
    }

    private CfgItemGame createGame(CfgItemGame cfgItemGame, String string, String string2, String string3, int n) {
        Object object;
        if (cfgItemGame == null) {
            cfgItemGame = new CfgItemGame();
            cfgItemGame.systemRom = this.getDefaultSystemRom();
            object = new CfgItemGameContainer(cfgItemGame);
            if (n >= 0) {
                ((ArrayList)this.games).add(n, object);
            } else {
                this.games.add((CfgItemGameContainer)object);
            }
        }
        object = String.valueOf(string) + "< " + new File(string2).getName() + " >";
        CfgItemCartridgeStandalone cfgItemCartridgeStandalone = new CfgItemCartridgeStandalone(string3, (String)object);
        cfgItemCartridgeStandalone.cartridgePath = string2;
        cfgItemGame.setCartridge(cfgItemCartridgeStandalone);
        return cfgItemGame;
    }

    public void reconcilePeripherals() {
        CfgItemPeripheral cfgItemPeripheral = this.portsDevices[0];
        CfgItemPeripheral cfgItemPeripheral2 = this.portsDevices[1];
        if (Peripherals.areExclusivePeripherals(cfgItemPeripheral.deviceID, cfgItemPeripheral2.deviceID)) {
            if (cfgItemPeripheral.isTransient() && cfgItemPeripheral2.isPersistent()) {
                this.portsDevices[1] = new CfgItemPeripheral(Peripherals.getDefaultPeripheralID(1), cfgItemPeripheral2);
                System.out.println("Reconciling gameport devices (#0=" + cfgItemPeripheral.deviceID + ", #1=" + cfgItemPeripheral2.deviceID + ") : Forcing #1 as " + this.portsDevices[1].deviceID);
            } else {
                this.portsDevices[0] = new CfgItemPeripheral(Peripherals.getDefaultPeripheralID(0), cfgItemPeripheral);
                System.out.println("Reconciling gameport devices (#0=" + cfgItemPeripheral.deviceID + ", #1=" + cfgItemPeripheral2.deviceID + ") : Forcing #0 as " + this.portsDevices[0].deviceID);
            }
        }
    }

    private void applyGameRequirements(CfgItemGame cfgItemGame) {
        if (cfgItemGame != null) {
            int n = 0;
            while (n < this.portsDevices.length) {
                CfgItemPeripheral cfgItemPeripheral = this.portsDevices[n].getPersistentInstance();
                this.portsDevices[n] = cfgItemGame.hasRequirements() && cfgItemGame.requirements[n] != null ? new CfgItemPeripheral(cfgItemGame.requirements[n], cfgItemPeripheral) : cfgItemPeripheral;
                ++n;
            }
        }
    }

    private CfgItemGame getDefaultGame() {
        CfgItemGame cfgItemGame = this.getGame("MINESTORM");
        if (cfgItemGame == null) {
            for (CfgItemGameContainer cfgItemGameContainer : this.games) {
                if (!cfgItemGameContainer.isGame()) continue;
                cfgItemGame = cfgItemGameContainer.game;
                if (cfgItemGame.cartridge.built || cfgItemGame.cartridge.picked) continue;
                return cfgItemGame;
            }
        }
        return cfgItemGame;
    }
}

